(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     62963,       1426]
NotebookOptionsPosition[     58125,       1282]
NotebookOutlinePosition[     58557,       1299]
CellTagsIndexPosition[     58514,       1296]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["2", "BookChapterNumber",
 CellChangeTimes->{3.4920561492443895`*^9}],

Cell["\:041f\:0440\:043e\:0441\:0442\:044b\:0435 \:0438 \:0441\:043e\:0441\
\:0442\:0430\:0432\:043d\:044b\:0435 \:0447\:0438\:0441\:043b\:0430", \
"BookChapterTitle",
 CellChangeTimes->{{3.4920561673715897`*^9, 3.4920561814583893`*^9}}],

Cell[CellGroupData[{

Cell["\:041f\:0440\:043e\:0441\:0442\:044b\:0435 \:0447\:0438\:0441\:043b\
\:0430", "Section",
 CellChangeTimes->{{3.4920562204115896`*^9, 3.49205622552839*^9}}],

Cell[TextData[{
 "\:041d\:0430\:0442\:0443\:0440\:0430\:043b\:044c\:043d\:043e\:0435 \:0447\
\:0438\:0441\:043b\:043e \:043d\:0430\:0437\:044b\:0432\:0430\:0435\:0442\
\:0441\:044f",
 StyleBox[" \:0441\:043e\:0441\:0442\:0430\:0432\:043d\:044b\:043c",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 ", \:0435\:0441\:043b\:0438 \:0435\:0433\:043e \
\:043c\:043e\:0436\:043d\:043e \:043f\:0440\:0435\:0434\:0441\:0442\:0430\
\:0432\:0438\:0442\:044c \:0432 \:0432\:0438\:0434\:0435 \:043f\:0440\:043e\
\:0438\:0437\:0432\:0435\:0434\:0435\:043d\:0438\:044f \:0434\:0432\:0443\
\:0445 \:043c\:0435\:043d\:044c\:0448\:0438\:0445 \:043d\:0430\:0442\:0443\
\:0440\:0430\:043b\:044c\:043d\:044b\:0445 \:0447\:0438\:0441\:0435\:043b. \
\:0417\:0430\:043c\:0435\:0442\:0438\:043c, \:0447\:0442\:043e \:043e\:0431\
\:0430 \:043c\:043d\:043e\:0436\:0438\:0442\:0435\:043b\:044f \:043f\:0440\
\:0438 \:044d\:0442\:043e\:043c \:043e\:0442\:043b\:0438\:0447\:043d\:044b \
\:043e\:0442 1. \:041d\:0435\:043a\:043e\:0442\:043e\:0440\:044b\:0435 \:043d\
\:0430\:0442\:0443\:0440\:0430\:043b\:044c\:043d\:044b\:0435 \:0447\:0438\
\:0441\:043b\:0430, \:043e\:0442\:043b\:0438\:0447\:043d\:044b\:0435 \:043e\
\:0442 1, \:043d\:0435\:043b\:044c\:0437\:044f \:043f\:0440\:0435\:0434\:0441\
\:0442\:0430\:0432\:0438\:0442\:044c \:0432 \:0432\:0438\:0434\:0435 \:043f\
\:0440\:043e\:0438\:0437\:0432\:0435\:0434\:0435\:043d\:0438\:044f \:043c\
\:0435\:043d\:044c\:0448\:0438\:0445 \:043c\:043d\:043e\:0436\:0438\:0442\
\:0435\:043b\:0435\:0439. \:0422\:0430\:043a\:0438\:0435 \:0447\:0438\:0441\
\:043b\:0430 \:043d\:0430\:0437\:044b\:0432\:0430\:044e\:0442\:0441\:044f ",
 StyleBox["\:043f\:0440\:043e\:0441\:0442\:044b\:043c\:0438.",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.4920570299613895`*^9, 3.4920570550461893`*^9}, {
  3.4920570987261896`*^9, 3.4920571372581897`*^9}, {3.4920573242709894`*^9, 
  3.49205734336539*^9}}],

Cell["\<\
\:041f\:0440\:043e\:0432\:0435\:0440\:0438\:0442\:044c, \:044f\:0432\:043b\
\:044f\:0435\:0442\:0441\:044f \:0446\:0435\:043b\:043e\:0435 \:0447\:0438\
\:0441\:043b\:043e \:043f\:0440\:043e\:0441\:0442\:044b\:043c \:0438\:043b\
\:0438 \:043d\:0435\:0442, \:043c\:043e\:0436\:043d\:043e \:0441\:043b\:0435\
\:0434\:0443\:044e\:0449\:0438\:043c \:043e\:0431\:0440\:0430\:0437\:043e\
\:043c.\
\>", "Text",
 CellChangeTimes->{{3.4920573830361896`*^9, 3.4920574156401896`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", "11111", "]"}]], "Input",
 CellChangeTimes->{{3.4920574292901897`*^9, 3.4920574372149897`*^9}}],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.4920574403193893`*^9}]
}, Closed]],

Cell[BoxData[
 RowBox[{"PrimeQ", "[", "7919", "]"}]], "Input",
 CellChangeTimes->{{3.4951223952935534`*^9, 3.495122410118553*^9}}],

Cell[TextData[{
 "\:0427\:0438\:0441\:043b\:043e 11111 \:043d\:0435 \:043f\:0440\:043e\:0441\
\:0442\:043e\:0435, \:0430 \:0441\:043e\:0441\:0442\:0430\:0432\:043d\:043e\
\:0435. \:041f\:0440\:043e\:0446\:0435\:0434\:0443\:0440\:0430 PrimeQ \:0441\
\:043d\:0430\:0447\:0430\:043b\:0430 \:043f\:0440\:043e\:0432\:0435\:0440\
\:044f\:0435\:0442 \:0434\:0435\:043b\:0438\:043c\:043e\:0441\:0442\:044c \
\:043d\:0430 \:043c\:0430\:043b\:044b\:0435 \:043f\:0440\:043e\:0441\:0442\
\:044b\:0435 \:0447\:0438\:0441\:043b\:0430, \:0437\:0430\:0442\:0435\:043c \
\:0438\:0441\:043f\:043e\:043b\:044c\:0437\:0443\:0435\:0442 \:0442\:0435\
\:0441\:0442 \:041c\:0438\:043b\:043b\:0435\:0440\:0430-\:0420\:0430\:0431\
\:0438\:043d\:0430 \:043f\:043e \:043e\:0441\:043d\:043e\:0432\:0430\:043d\
\:0438\:044f\:043c 2 \:0438 3, \:0438 \:0442\:0435\:0441\:0442 \:041b\:044e\
\:043a\:0430. \:041a\:0430\:0436\:0434\:044b\:0439 \:0438\:0437 \:044d\:0442\
\:0438\:0445 \:0442\:0435\:0441\:0442\:043e\:0432 \:043c\:043e\:0436\:0435\
\:0442 \:0433\:0430\:0440\:0430\:043d\:0442\:0438\:0440\:043e\:0432\:0430\
\:043d\:043d\:043e \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:0438\:0442\
\:044c \:043d\:0435\:043f\:0440\:043e\:0441\:0442\:043e\:0442\:0443 \:0447\
\:0438\:0441\:043b\:0430, \:043d\:043e \:043d\:0435 \:043c\:043e\:0436\:0435\
\:0442 \:0434\:043e\:043a\:0430\:0437\:0430\:0442\:044c \:043f\:0440\:043e\
\:0441\:0442\:043e\:0442\:0443. \:0414\:043b\:044f \:0433\:0430\:0440\:0430\
\:043d\:0442\:0438\:0440\:043e\:0432\:0430\:043d\:043d\:043e\:0433\:043e \
\:0434\:043e\:043a\:0430\:0437\:0430\:0442\:0435\:043b\:044c\:0441\:0442\:0432\
\:0430 \:043f\:0440\:043e\:0441\:0442\:043e\:0442\:044b \:0441\:0443\:0449\
\:0435\:0441\:0442\:0432\:0443\:0435\:0442 \:0444\:0443\:043d\:043a\:0446\
\:0438\:044f ProvablePrimeQ, \:043a\:043e\:0442\:043e\:0440\:0430\:044f \
\:0440\:0430\:0431\:043e\:0442\:0430\:0435\:0442 \:0441\:0443\:0449\:0435\
\:0441\:0442\:0432\:0435\:043d\:043d\:043e \:043c\:0435\:0434\:043b\:0435\
\:043d\:043d\:0435\:0435, \:0447\:0435\:043c PrimeQ. \:0414\:043e\:0441\:0442\
\:0430\:0442\:043e\:0447\:043d\:043e \:0432\:0440\:0435\:043c\:044f \:0440\
\:0430\:0431\:043e\:0442\:044b \:0441\:043b\:0435\:0434\:0443\:044e\:0449\
\:0438\:0445 \:0434\:0432\:0443\:0445 \:043f\:0440\:0438\:043c\:0435\:0440\
\:043e\:0432. (\:0424\:0443\:043d\:043a\:0446\:0438\:044f ProvablePrimeQ \
\:043d\:0430\:0445\:043e\:0434\:0438\:0442\:0441\:044f \:0432 \:043f\:0430\
\:043a\:0435\:0442\:0435 ",
 Cell[BoxData[
  FormBox["PrimalityProving", TraditionalForm]]],
 ", \:043a\:043e\:0442\:043e\:0440\:044b\:0439 \:0441\:043b\:0435\:0434\:0443\
\:0435\:0442 \:043f\:043e\:0434\:043a\:043b\:044e\:0447\:0438\:0442\:044c \
\:043e\:0442\:0434\:0435\:043b\:044c\:043d\:043e\:0439 \:043a\:043e\:043c\
\:0430\:043d\:0434\:043e\:0439)."
}], "Text",
 CellChangeTimes->{{3.4920574652169895`*^9, 3.4920574933749895`*^9}, {
  3.495114361770553*^9, 3.495114417572553*^9}, {3.495114496145553*^9, 
  3.4951144984195533`*^9}, {3.4951145536955533`*^9, 3.495114683624553*^9}, {
  3.495114727821553*^9, 3.4951147339325533`*^9}, {3.495115239525553*^9, 
  3.4951152567415533`*^9}, {3.4951158040905533`*^9, 3.495115828766553*^9}, {
  3.4951158606595535`*^9, 3.495115894391553*^9}}],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PrimalityProving`\>\"", "]"}]], "Input",
 CellChangeTimes->{
  3.4951159024355536`*^9, {3.4951165031165533`*^9, 3.495116508429553*^9}}],

Cell[BoxData[
 RowBox[{"ProvablePrimeQ", "[", 
  RowBox[{
   RowBox[{"10", "^", "150"}], "+", "67"}], "]"}]], "Input",
 CellChangeTimes->{{3.4951147362545533`*^9, 3.495114759231553*^9}, {
  3.495115231309553*^9, 3.4951152326615534`*^9}, {3.495119459872553*^9, 
  3.4951194634065533`*^9}, {3.495119577198553*^9, 3.495119578788553*^9}}],

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{
   RowBox[{"10", "^", "150"}], "+", "67"}], "]"}]], "Input",
 CellChangeTimes->{{3.495115391737553*^9, 3.495115400046553*^9}, {
  3.495119467664553*^9, 3.4951194713575535`*^9}, {3.495119583455553*^9, 
  3.495119585035553*^9}}],

Cell["\<\
\:0418\:0437\:0432\:0435\:0441\:0442\:043d\:043e, \:0447\:0442\:043e \:043d\
\:0430 \:0447\:0438\:0441\:043b\:0430\:0445, \:043d\:0435 \:043f\:0440\:0435\
\:0432\:043e\:0441\:0445\:043e\:0434\:044f\:0449\:0438\:0445 10^16, \:0444\
\:0443\:043d\:043a\:0446\:0438\:044f PrimeQ \:0432\:044b\:0434\:0430\:0435\
\:0442 \:0433\:0430\:0440\:0430\:043d\:0442\:0438\:0440\:043e\:0432\:0430\
\:043d\:043d\:043e \:0432\:0435\:0440\:043d\:044b\:0439 \:0440\:0435\:0437\
\:0443\:043b\:044c\:0442\:0430\:0442.\
\>", "Text",
 CellChangeTimes->{{3.4951154127745533`*^9, 3.495115429443553*^9}, {
  3.495115554874553*^9, 3.4951155929325533`*^9}, {3.495115670292553*^9, 
  3.495115716806553*^9}, {3.495122362002553*^9, 3.495122362063553*^9}}],

Cell["\<\
\:0421\:043b\:0435\:0434\:0443\:044e\:0449\:0430\:044f \:043a\:043e\:043c\
\:0430\:043d\:0434\:0430 \:0432\:044b\:0434\:0430\:0451\:0442 \:0442\:044b\
\:0441\:044f\:0447\:043d\:043e\:0435 \:043f\:043e \:043f\:043e\:0440\:044f\
\:0434\:043a\:0443 \:043f\:0440\:043e\:0441\:0442\:043e\:0435 \:0447\:0438\
\:0441\:043b\:043e.\
\>", "Text",
 CellChangeTimes->{{3.4920576220593896`*^9, 3.4920576410445895`*^9}, {
  3.4937429668144274`*^9, 3.493742996392028*^9}, {3.4951224255415535`*^9, 
  3.495122427226553*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prime", "[", "1000", "]"}]], "Input",
 CellChangeTimes->{{3.4920575574597893`*^9, 3.4920575661489897`*^9}, {
  3.4937430025384274`*^9, 3.4937430113680277`*^9}}],

Cell[BoxData["7919"], "Output",
 CellChangeTimes->{
  3.4920575680677896`*^9, {3.4937430059704275`*^9, 3.4937430142540274`*^9}}]
}, Closed]],

Cell["\<\
\:041f\:043e\:043f\:0440\:043e\:0431\:0443\:0439\:0442\:0435 \:043f\:043e\
\:0441\:043b\:0435\:0434\:043e\:0432\:0430\:0442\:0435\:043b\:044c\:043d\:043e\
 \:0432\:044b\:043f\:043e\:043b\:043d\:0438\:0442\:044c \:0441\:043b\:0435\
\:0434\:0443\:044e\:0449\:0438\:0435 \:0442\:0440\:0438 \:043a\:043e\:043c\
\:0430\:043d\:0434\:044b (\:043e\:0442\:043c\:0435\:043d\:0438\:0442\:044c \
\:0437\:0430\:043f\:0443\:0449\:0435\:043d\:043d\:0443\:044e \:043a\:043e\
\:043c\:0430\:043d\:0434\:0443 \:043c\:043e\:0436\:043d\:043e \:043a\:043e\
\:043c\:0431\:0438\:043d\:0430\:0446\:0438\:0435\:0439 Alt+.)  \
\>", "Text",
 CellChangeTimes->{{3.4951178502085533`*^9, 3.4951179368345532`*^9}}],

Cell[BoxData[
 RowBox[{"Prime", "[", 
  RowBox[{"10", "^", "10"}], "]"}]], "Input",
 CellChangeTimes->{{3.4951179562585535`*^9, 3.495117958872553*^9}}],

Cell[BoxData[
 RowBox[{"Prime", "[", 
  RowBox[{"10", "^", "11"}], "]"}]], "Input",
 CellChangeTimes->{{3.495117963763553*^9, 3.495117974670553*^9}}],

Cell[BoxData[
 RowBox[{"Prime", "[", 
  RowBox[{"10", "^", "12"}], "]"}]], "Input",
 CellChangeTimes->{3.495117994863553*^9}],

Cell[TextData[{
 "\:0421\:043e\:0441\:0442\:0430\:0432\:0438\:043c \:0441\:043f\:0438\:0441\
\:043e\:043a \:0432\:0441\:0435\:0445 \:043f\:0440\:043e\:0441\:0442\:044b\
\:0445 \:0447\:0438\:0441\:0435\:043b \:0432\:0438\:0434\:0430 ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["n", "2"], TraditionalForm]]],
 "+1, \:043c\:0435\:043d\:044c\:0448\:0438\:0445 10000."
}], "Text",
 CellChangeTimes->{{3.4920578950905895`*^9, 3.4920579540741897`*^9}, {
  3.4920606808293896`*^9, 3.4920606823269897`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "1"}], ";", 
  RowBox[{"A", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"n", "^", "2"}], "+", "1"}], "<", 
     RowBox[{"10", "^", "4"}]}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PrimeQ", "[", 
        RowBox[{
         RowBox[{"n", "^", "2"}], "+", "1"}], "]"}], ",", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"A", ",", 
         RowBox[{
          RowBox[{"n", "^", "2"}], "+", "1"}]}], "]"}]}], "]"}], ";", 
     RowBox[{"n", "++"}]}]}], "]"}], ";", "A"}]], "Input",
 CellChangeTimes->{{3.4920584473461895`*^9, 3.4920585014157896`*^9}, {
  3.4920585336765895`*^9, 3.4920585483873897`*^9}, {3.4920586070589895`*^9, 
  3.4920586305057898`*^9}, {3.4920586727349896`*^9, 3.4920586793181896`*^9}, {
  3.4920587107209897`*^9, 3.4920587144493895`*^9}, {3.49205879706699*^9, 
  3.4920587999841895`*^9}, {3.4920597182625895`*^9, 3.4920597323805895`*^9}, {
  3.4920604112145896`*^9, 3.49206045877899*^9}, {3.4920605075757895`*^9, 
  3.4920605668869896`*^9}, {3.4920606036093893`*^9, 3.49206061289139*^9}, {
  3.49206064869339*^9, 3.4920606686613894`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "5", ",", "17", ",", "37", ",", "101", ",", "197", ",", "257", 
   ",", "401", ",", "577", ",", "677", ",", "1297", ",", "1601", ",", "2917", 
   ",", "3137", ",", "4357", ",", "5477", ",", "7057", ",", "8101", ",", 
   "8837"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4920606185385895`*^9, {3.4920606547461896`*^9, 3.4920606703305893`*^9}, 
   3.4920614200509896`*^9}]
}, Closed]],

Cell["\<\
\:041f\:0440\:043e\:0433\:0440\:0430\:043c\:043c\:0430 \:0441\:043e\:0431\
\:0438\:0440\:0430\:0435\:0442 \:0432\:0441\:0435 \:043d\:0443\:0436\:043d\
\:044b\:0435 \:043f\:0440\:043e\:0441\:0442\:044b\:0435 \:0447\:0438\:0441\
\:043b\:0430 \:0432 \:043c\:043d\:043e\:0436\:0435\:0441\:0442\:0432\:0435 A. \
\:0427\:0442\:043e\:0431\:044b \:0441\:043e\:0441\:0447\:0438\:0442\:0430\
\:0442\:044c \:0438\:0445 \:043a\:043e\:043b\:0438\:0447\:0435\:0441\:0442\
\:0432\:043e \:0434\:043e\:0441\:0442\:0430\:0442\:043e\:0447\:043d\:043e \
\:0432\:043e\:0441\:043f\:043e\:043b\:044c\:0437\:043e\:0432\:0430\:0442\:044c\
\:0441\:044f \:043a\:043e\:043c\:0430\:043d\:0434\:043e\:0439\
\>", "Text",
 CellChangeTimes->{{3.49206079224459*^9, 3.4920607989681897`*^9}, {
  3.4920608766405897`*^9, 3.49206095858739*^9}, {3.49206135381339*^9, 
  3.4920613894593897`*^9}, {3.4937430683704276`*^9, 3.4937430956080275`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "A", "]"}]], "Input",
 CellChangeTimes->{{3.49206098688579*^9, 3.4920611483925896`*^9}, {
  3.4920611957697897`*^9, 3.4920613074813895`*^9}, {3.4920613988193893`*^9, 
  3.49206141356139*^9}}],

Cell[BoxData["19"], "Output",
 CellChangeTimes->{{3.4920610411269894`*^9, 3.4920611214357896`*^9}, 
   3.49206115315059*^9, {3.4920611997477894`*^9, 3.49206130921299*^9}, 
   3.4920614250117893`*^9}]
}, Closed]],

Cell["\<\
\:0421\:043b\:0435\:0434\:0443\:044e\:0449\:0430\:044f \:043a\:043e\:043c\
\:0430\:043d\:0434\:0430 \:0432\:044b\:0432\:043e\:0434\:0438\:0442 \:043f\
\:0435\:0440\:0432\:044b\:0439 20 \:043f\:0440\:043e\:0441\:0442\:044b\:0445 \
\:0447\:0438\:0441\:0435\:043b.\
\>", "Text",
 CellChangeTimes->{{3.495281061609375*^9, 3.495281074140625*^9}}],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Prime", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.49528112025*^9}],

Cell["\<\
\:0410 \:0432\:043e\:0442 \:0438\:043d\:0442\:0435\:0440\:0435\:0441\:043d\
\:044b\:0439 \:043f\:0440\:0438\:043c\:0435\:0440 \:043f\:0440\:0438\:043c\
\:0435\:043d\:0435\:043d\:0438\:044f \:0441\:0438\:043c\:0432\:043e\:043b\
\:044c\:043d\:044b\:0445 \:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\
\:0438\:0439\
\>", "Text",
 CellChangeTimes->{{3.4952812175*^9, 3.49528124634375*^9}}],

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"Prime", "[", "n", "]"}], "^", "s"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.495281254*^9}],

Cell["\<\
\:041c\:043e\:0436\:043d\:043e \:0442\:0430\:043a\:0436\:0435 \:0438\:0437\
\:0443\:0447\:0430\:0442\:044c \:0433\:0440\:0430\:0444\:0438\:0447\:0435\
\:0441\:043a\:0438 \:0440\:0430\:0437\:043b\:0438\:0447\:043d\:044b\:0435 \
\:0437\:0430\:043a\:043e\:043d\:043e\:043c\:0435\:0440\:043d\:043e\:0441\:0442\
\:0438 \:0440\:0430\:0441\:043f\:0440\:0435\:0434\:0435\:043b\:0435\:043d\
\:0438\:044f \:043f\:0440\:043e\:0441\:0442\:044b\:0445 \:0447\:0438\:0441\
\:0435\:043b. \
\>", "Text",
 CellChangeTimes->{{3.49528131184375*^9, 3.49528135609375*^9}, {
  3.495281390234375*^9, 3.495281395609375*^9}}],

Cell[BoxData[
 RowBox[{"DiscretePlot", "[", 
  RowBox[{
   RowBox[{"Prime", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.49528137128125*^9, {3.495281416828125*^9, 3.49528141940625*^9}}],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Prime", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495281422171875*^9, 3.49528143403125*^9}}],

Cell["\<\
\:0421\:043b\:0435\:0434\:0443\:044e\:0449\:0430\:044f \:043a\:043e\:043c\
\:0430\:043d\:0434\:0430 \:0433\:0440\:0430\:0444\:0438\:0447\:0435\:0441\
\:043a\:0438 \:043f\:043e\:043a\:0430\:0437\:044b\:0432\:0430\:0435\:0442, \
\:043a\:0430\:043a \:0432\:0435\:0434\:0435\:0442 \:0441\:0435\:0431\:044f \
\:0440\:0430\:0441\:0441\:0442\:043e\:044f\:043d\:0438\:0435 \:043c\:0435\
\:0436\:0434\:0443 \:0441\:043e\:0441\:0435\:0434\:043d\:0438\:043c\:0438 \
\:043f\:0440\:043e\:0441\:0442\:044b\:043c\:0438 \:0447\:0438\:0441\:043b\
\:0430\:043c\:0438.\
\>", "Text",
 CellChangeTimes->{{3.49528144759375*^9, 3.49528147715625*^9}, 
   3.495287308984375*^9}],

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prime", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "-", 
     RowBox[{"Prime", "[", "n", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4952814788125*^9, 3.49528148659375*^9}}],

Cell["\<\
\:0421\:043b\:0435\:0434\:0443\:044e\:0449\:0438\:0439 \:0433\:0440\:0430\
\:0444\:0438\:043a \:0438\:043b\:043b\:044e\:0441\:0442\:0440\:0438\:0440\
\:0443\:0435\:0442 \:0430\:0441\:0438\:043c\:043f\:0442\:043e\:0442\:0438\
\:0447\:0435\:0441\:043a\:0443\:044e \:0444\:043e\:0440\:043c\:0443\:043b\
\:0443 \:0434\:043b\:044f n-\:0433\:043e \:043f\:0440\:043e\:0441\:0442\:043e\
\:0433\:043e \:0447\:0438\:0441\:043b\:0430.\
\>", "Text",
 CellChangeTimes->{{3.49528725834375*^9, 3.49528730346875*^9}, {
  3.495287391546875*^9, 3.495287402171875*^9}}],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", " ", 
       RowBox[{"Log", "[", "n", "]"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495287311359375*^9, 3.4952873234375*^9}}],

Cell["\<\
\:0410 \:0432\:043e\:0442 \:043a\:0430\:043a \:043f\:043e\:0432\:0435\:0434\
\:0435\:0442 \:0441\:0435\:0431\:044f \:0440\:0430\:0437\:043d\:043e\:0441\
\:0442\:044c \:043c\:0435\:0436\:0434\:0443 n-\:043c \:043f\:0440\:043e\:0441\
\:0442\:044b\:043c \:0447\:0438\:0441\:043b\:043e\:043c \:0438 \:0430\:0441\
\:0438\:043c\:043f\:0442\:043e\:0442\:0438\:043a\:043e\:0439\
\>", "Text",
 CellChangeTimes->{{3.495287726625*^9, 3.49528773*^9}, {3.495287779328125*^9, 
  3.495287801796875*^9}}],

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], "-", 
     RowBox[{"n", " ", 
      RowBox[{"Log", "[", "n", "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.495287804421875*^9, 3.495287809703125*^9}}],

Cell["\<\
\:041e\:0434\:043d\:043e\:0439 \:0438\:0437 \:0441\:0430\:043c\:044b\:0445 \
\:0432\:0430\:0436\:043d\:044b\:0445 \:0444\:0443\:043a\:043d\:0446\:0438\
\:0439 \:0432 \:0442\:0435\:043e\:0440\:0438\:0438 \:0447\:0438\:0441\:0435\
\:043b \:044f\:0432\:043b\:044f\:0435\:0442\:0441\:044f pi(x) - \:043a\:043e\
\:043b\:0438\:0447\:0435\:0441\:0442\:0432\:043e \:043f\:0440\:043e\:0441\
\:0442\:044b\:0445 \:0447\:0438\:0441\:0435\:043b, \:043d\:0435 \:043f\:0440\
\:0435\:0432\:043e\:0441\:0445\:043e\:0434\:044f\:0449\:0438\:0445 x. \
\>", "Text",
 CellChangeTimes->{{3.49528780459375*^9, 3.49528780459375*^9}, {
  3.4952878861875*^9, 3.49528789003125*^9}, {3.495288232140625*^9, 
  3.495288249546875*^9}, {3.495290053171875*^9, 3.495290055546875*^9}}],

Cell["\<\
\:041a\:043e\:043b\:0438\:0447\:0435\:0441\:0442\:0432\:043e \:043f\:0440\
\:043e\:0441\:0442\:044b\:0445 \:0447\:0438\:0441\:0435\:043b, \:043d\:0435 \
\:043f\:0440\:0435\:0432\:043e\:0441\:0445\:043e\:0434\:044f\:0449\:0438\:0445\
 10^9\
\>", "Text",
 CellChangeTimes->{{3.49528780459375*^9, 3.49528780459375*^9}, {
  3.4952878861875*^9, 3.49528789003125*^9}, {3.495288232140625*^9, 
  3.495288249546875*^9}, {3.495290053171875*^9, 3.4952900555*^9}}],

Cell[BoxData[
 RowBox[{"PrimePi", "[", 
  RowBox[{"10", "^", "9"}], "]"}]], "Input",
 CellChangeTimes->{3.495288261375*^9}],

Cell["\<\
\:0421\:043b\:0435\:0434\:0443\:044e\:0449\:0430\:044f \:043a\:043e\:043c\
\:0430\:043d\:0434\:0430 \:0432\:044b\:0432\:043e\:0434\:0438\:0442 \:043f\
\:043e\:0441\:043b\:0435\:0434\:043e\:0432\:0430\:0442\:0435\:043b\:044c\:043d\
\:043e\:0441\:0442\:044c \:0437\:043d\:0430\:0447\:0435\:043d\:0438\:0439 \
\:0444\:0443\:043a\:043d\:0446\:0438\:0438 pi(x)\
\>", "Text",
 CellChangeTimes->{{3.49528829628125*^9, 3.495288341453125*^9}}],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PrimePi", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.495288344953125*^9}],

Cell["\:0413\:0440\:0430\:0444\:0438\:043a \:044d\:0442\:043e\:0439 \:0444\
\:0443\:043d\:043a\:0446\:0438\:0438", "Text",
 CellChangeTimes->{{3.495286979359375*^9, 3.495287197734375*^9}, 
   3.495287241875*^9, {3.495288364921875*^9, 3.4952883785625*^9}, {
   3.495288678328125*^9, 3.495288687546875*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PrimePi", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.495288381703125*^9, 3.49528838496875*^9}, {
  3.495288699546875*^9, 3.4952887*^9}}],

Cell["\<\
\:0418\:043b\:043b\:044e\:0441\:0442\:0440\:0430\:0446\:0438\:044f \:043f\
\:043e\:0432\:0435\:0434\:0435\:043d\:0438\:044f \:0430\:0441\:0438\:043c\
\:043f\:0442\:043e\:0442\:0438\:0447\:0435\:0441\:043a\:0438\:0445 \:0444\
\:043e\:0440\:043c\:0443\:043b \:0434\:043b\:044f \:0444\:0443\:043d\:043a\
\:0446\:0438\:0438 pi(x)\
\>", "Text",
 CellChangeTimes->{{3.495288740515625*^9, 3.495288762734375*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"PrimePi", "[", "n", "]"}], ",", 
     RowBox[{"n", "/", 
      RowBox[{"Log", "[", "n", "]"}]}], ",", 
     RowBox[{"LogIntegral", "[", "n", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1.5", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.49528876959375*^9}],

Cell[TextData[{
 "\:0433\:0434\:0435 \:0444\:0443\:043d\:043a\:0446\:0438\:044f LogIntegral \
\:043e\:043f\:0440\:0435\:0434\:0435\:043b\:044f\:0435\:0442\:0441\:044f \
\:0440\:0430\:0432\:0435\:043d\:0441\:0442\:0432\:043e\:043c ",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"li", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      RowBox[{
       RowBox[{"d", "t"}], "/", "log"}], " ", "t", " "}]}]}], 
   TraditionalForm]], "InlineMath"]
}], "Text",
 CellChangeTimes->{{3.495289472375*^9, 3.495289506390625*^9}}],

Cell[TextData[{
 "\:0415\:0449\:0435 \:043e\:0434\:043d\:0438\:043c \:0438\:043d\:0442\:0435\
\:0440\:0435\:0441\:043d\:044b\:043c \:043f\:0440\:0438\:0431\:043b\:0438\
\:0436\:0435\:043d\:0438\:0435\:043c \:043a \:0444\:0443\:043d\:0446\:0438\
\:0438 pi(x) \:044f\:0432\:043b\:044f\:0435\:0442\:0441\:044f \:0444\:0443\
\:043d\:043a\:0446\:0438\:044f \:0420\:0438\:043c\:0430\:043d\:0430, \:043e\
\:043f\:0440\:0435\:0434\:0435\:043b\:044f\:0435\:043c\:0430\:044f \:0440\
\:0430\:0432\:0435\:043d\:0441\:0442\:0432\:043e\:043c ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"R", "(", "x", ")"}], "\[LongEqual]", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", "n", "\[Infinity]"], 
     RowBox[{
      RowBox[{
       TagBox["\[Mu]",
        MoebiusMu], "(", "n", ")"}], " ", 
      RowBox[{
       RowBox[{"li", "(", 
        SuperscriptBox["x", 
         RowBox[{"1", "/", "n"}]], ")"}], "/", "n"}]}]}]}], TraditionalForm]]],
 " . \:0421\:043b\:0435\:0434\:0443\:044e\:0449\:0438\:0439 \
\:0433\:0440\:0430\:0444\:0438\:043a \:043f\:043e\:043a\:0430\:0437\:044b\
\:0432\:0430\:0435\:0442, \:043d\:0430\:0441\:043a\:043e\:043b\:044c\:043a\
\:043e \:0431\:043b\:0438\:0437\:043a\:0430 \:043e\:043a\:0430\:0437\:044b\
\:0432\:0430\:0435\:0442\:0441\:044f R(x) \:043a pi(x)"
}], "Text",
 CellChangeTimes->{{3.495289518890625*^9, 3.49528951890625*^9}, {
  3.49528989078125*^9, 3.49528998053125*^9}, {3.495290013296875*^9, 
  3.495290043703125*^9}, {3.49529008046875*^9, 3.49529009334375*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RiemannR", "[", "x", "]"}], ",", 
     RowBox[{"PrimePi", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.495290095859375*^9, 3.49529010125*^9}}],

Cell["\<\
\:0412\:043e \:0442\:0430\:043a \:0432\:0435\:0434\:0435\:0442 \:0441\:0435\
\:0431\:044f \:0440\:0430\:0437\:043d\:043e\:0441\:0442\:044c \:044d\:0442\
\:0438\:0445 \:0444\:0443\:043d\:043a\:0446\:0438\:0439 \:043d\:0430 \:0431\
\:043e\:043b\:044c\:0448\:043e\:043c \:043f\:0440\:043e\:043c\:0435\:0436\
\:0443\:0442\:043a\:0435\
\>", "Text",
 CellChangeTimes->{{3.495289179578125*^9, 3.495289191234375*^9}, {
  3.4952901218125*^9, 3.4952901378125*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RiemannR", "[", "n", "]"}], "-", 
     RowBox[{"PrimePi", "[", "n", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "100000"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.49528725440625*^9, 3.49528725453125*^9}, {
   3.495289250703125*^9, 3.495289287421875*^9}, {3.495289375671875*^9, 
   3.4952893986875*^9}, 3.495289729046875*^9, 3.495290141828125*^9}],

Cell["\<\
\:0424\:0443\:043d\:043a\:0446\:0438\:044f NextPrime[n] \:0441\:0442\:0440\
\:043e\:0438\:0442 \:043d\:0430\:0438\:043c\:0435\:043d\:044c\:0448\:0435\
\:0435 \:043f\:0440\:043e\:0441\:0442\:043e\:0435 \:0447\:0438\:0441\:043b\
\:043e, \:0431\:043e\:043b\:044c\:0448\:0435\:0435 n, \:0430 \:0444\:0443\
\:043d\:043a\:0446\:0438\:044f NextPrime[n,k] \:043d\:0430\:0445\:043e\:0434\
\:0438\:0442 k-\:0435 \:043f\:043e \:0432\:043e\:0437\:0440\:0430\:0441\:0442\
\:0430\:043d\:0438\:044e \:0447\:0438\:0441\:043b\:043e \:0441\:0440\:0435\
\:0434\:0438 \:0432\:0441\:0435\:0445 \:043f\:0440\:043e\:0441\:0442\:044b\
\:0445 \:0431\:043e\:043b\:044c\:0448\:0438\:0445 n. \:0412\:043e\:0442 \
\:043d\:0435\:043a\:043e\:0442\:043e\:0440\:044b\:0435 \:043f\:0440\:0438\
\:043c\:0435\:0440\:044b.\
\>", "Text",
 CellChangeTimes->{{3.4953187581*^9, 3.495318787308*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
\:0413\:0435\:043d\:0435\:0440\:0430\:0446\:0438\:044f \:0431\:043e\:043b\
\:044c\:0448\:0438\:0445 \:043f\:0440\:043e\:0441\:0442\:044b\:0445 \:0447\
\:0438\:0441\:0435\:043b\
\>", "Section",
 CellChangeTimes->{{3.495318761421*^9, 3.495318769711*^9}}],

Cell["\<\
\:0412 \:041c\:0430\:0442\:0435\:043c\:0430\:0442\:0438\:043a\:0435 \:0435\
\:0441\:0442\:044c \:0432\:0441\:0442\:0440\:043e\:0435\:043d\:043d\:0430\
\:044f \:0444\:0443\:043d\:043a\:0446\:0438\:044f NextPrime, \:043a\:043e\
\:0442\:043e\:0440\:0430\:044f \:043f\:043e\:0437\:0432\:043e\:043b\:044f\
\:0435\:0442 \:043f\:043e\:043b\:0443\:0447\:0430\:0442\:044c \:0431\:043e\
\:043b\:044c\:0448\:0438\:0435 \:043f\:0440\:043e\:0441\:0442\:044b\:0435 \
\:0447\:0438\:0441\:043b\:0430.\
\>", "Text",
 CellChangeTimes->{{3.495322633557*^9, 3.495322635712*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", 
  RowBox[{"10", "^", "300"}], "]"}]], "Input",
 CellChangeTimes->{{3.4920617824233894`*^9, 3.4920618216417894`*^9}, {
  3.4920619244613895`*^9, 3.4920619349757895`*^9}}],

Cell[BoxData[\
"10000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000000000331"], \
"Output",
 CellChangeTimes->{{3.4920618115953894`*^9, 3.4920618242625895`*^9}, {
  3.4920619215909896`*^9, 3.4920619381737895`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", 
  RowBox[{
   RowBox[{"10", "^", "300"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.49206215194059*^9, 3.4920622290981894`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "100000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000000000000000000000000000000000000000387", ",", 
   "10000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000000000000723", ",",
    "1000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000001051", 
   ",", "999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999931"}]\
, "}"}]], "Output",
 CellChangeTimes->{{3.4920621566517897`*^9, 3.4920621723609896`*^9}, {
  3.4920622083501897`*^9, 3.49206223589979*^9}}]
}, Closed]],

Cell[TextData[{
 "\:0412\:0442\:043e\:0440\:044b\:043c \:0430\:0440\:0433\:0443\:043c\:0435\
\:043d\:0442\:043e\:043c \:0444\:0443\:043d\:043a\:0446\:0438\:0438 NextPrime \
\:043c\:043e\:0436\:0435\:0442 \:0431\:044b\:0442\:044c \:043c\:043d\:043e\
\:0436\:0435\:0441\:0442\:0432\:043e \:0438\:043d\:0434\:0435\:043a\:0441\
\:043e\:0432 k, \:043f\:0440\:0438\:0447\:0435\:043c \:044d\:0442\:0438 \
\:0438\:043d\:0434\:0435\:043a\:0441\:044b \:043c\:043e\:0433\:0443\:0442 \
\:0431\:044b\:0442\:044c \:0438 \:043e\:0442\:0440\:0438\:0446\:0430\:0442\
\:0435\:043b\:044c\:043d\:044b\:043c\:0438. \:041d\:0430\:043f\:0440\:0438\
\:043c\:0435\:0440, \:043f\:0440\:0438 k = -1 \:0438\:0449\:0435\:0442\:0441\
\:044f \:043f\:0440\:0435\:0434\:044b\:0434\:0443\:0449\:0435\:0435 \:043f\
\:0440\:043e\:0441\:0442\:043e\:0435 \:0447\:0438\:0441\:043b\:043e \:043e\
\:0442\:043d\:043e\:0441\:0438\:0442\:0435\:043b\:044c\:043d\:043e \:043f\
\:0435\:0440\:0432\:043e\:0433\:043e \:0430\:0440\:0433\:0443\:043c\:0435\
\:043d\:0442\:0430. \:041a\:0430\:043a \:0438\:043c\:0435\:043d\:043d\:043e \
\:0440\:0430\:0431\:043e\:0442\:0430\:0435\:0442 \:0444\:0443\:043d\:043a\
\:0446\:0438\:044f ",
 Cell[BoxData[
  FormBox["NextPrime", TraditionalForm]]],
 ", \:0432 \:0434\:043e\:043a\:0443\:043c\:0435\:043d\:0442\:0430\:0446\:0438\
\:0438 \:043d\:0435 \:0441\:043a\:0430\:0437\:0430\:043d\:043e, \:043d\:043e \
\:043c\:043e\:0436\:043d\:043e \:043f\:0440\:0435\:0434\:043f\:043e\:043b\
\:043e\:0436\:0438\:0442\:044c, \:0447\:0442\:043e \:043e\:0441\:0443\:0449\
\:0435\:0441\:0442\:0432\:043b\:044f\:0442\:0435\:0441\:044f \:043f\:043e\
\:0441\:043b\:0435\:0434\:043e\:0432\:0430\:0442\:0435\:043b\:044c\:043d\:044b\
\:0439 \:043f\:0435\:0440\:0435\:0431\:043e\:0440 \:043d\:0430\:0442\:0443\
\:0440\:0430\:043b\:044c\:043d\:044b\:0445 \:0447\:0438\:0441\:0435\:043b, \
\:043d\:0430\:0447\:0438\:043d\:0430\:044f \:0441 \:043f\:0435\:0440\:0432\
\:043e\:0433\:043e \:0430\:0440\:0433\:0443\:043c\:0435\:043d\:0442\:0430, \
\:0438 \:0434\:043b\:044f \:043a\:0430\:0436\:0434\:043e\:0433\:043e \:0432\
\:044b\:0437\:044b\:0432\:0430\:0435\:0442\:0441\:044f \:0444\:0443\:043a\
\:043d\:0446\:0438\:044f PrimeQ. \:0422\:043e\:043b\:044c\:043a\:043e \:0442\
\:0430\:043a \:043c\:043e\:0436\:043d\:043e \:043e\:0431\:044a\:044f\:0441\
\:043d\:0438\:0442\:044c \:0442\:043e, \:0447\:0442\:043e NextPrime \:0440\
\:0430\:0431\:043e\:0442\:0430\:0435\:0442 \:0431\:044b\:0441\:0442\:0440\
\:043e \:0438 \:043d\:0430 \:0447\:0438\:0441\:043b\:0430\:0445 \:043f\:043e\
\:0440\:044f\:0434\:043a\:0430 10^300 \:0438 \:0431\:043e\:043b\:0435\:0435. \
\:041f\:043e\:044d\:0442\:043e\:043c\:0443 \:0440\:0435\:0437\:0443\:043b\
\:044c\:0442\:0430\:0442\:043e\:043c \:0440\:0430\:0431\:043e\:0442\:044b \
\:0444\:0443\:043d\:043a\:0446\:0438\:0438 NextPrime \:0442\:0435\:043e\:0440\
\:0435\:0442\:0438\:0447\:0435\:0441\:043a\:0438 \:043c\:043e\:0436\:0435\
\:0442 \:043e\:043a\:0430\:0437\:0430\:0442\:044c\:0441\:044f \:0441\:043e\
\:0441\:0442\:0430\:0432\:043d\:043e\:0435 \:0447\:0438\:0441\:043b\:043e."
}], "Text",
 CellChangeTimes->{3.4951223468525534`*^9}],

Cell["\<\
\:0415\:0441\:043b\:0438 \:043d\:0443\:0436\:043d\:043e \:043f\:043e\:0441\
\:0442\:0440\:043e\:0438\:0442\:044c \:043f\:0441\:0435\:0432\:0434\:043e\
\:0441\:043b\:0443\:0447\:0430\:0439\:043d\:043e\:0435 \:043f\:0440\:043e\
\:0441\:0442\:043e\:0435 \:0447\:0438\:0441\:043b\:043e, \:043b\:0435\:0436\
\:0430\:0449\:0435\:0435 \:043c\:0435\:0436\:0434\:0443 a \:0438 b \:043c\
\:043e\:0436\:043d\:043e \:0432\:043e\:0441\:043f\:043e\:043b\:044c\:0437\
\:043e\:0432\:0430\:0442\:044c\:0441\:044f \:043a\:043e\:043c\:0430\:043d\
\:0434\:043e\:0439 RandomPrime[{a,b}]. \:0414\:043b\:044f \:043f\:043e\:0441\
\:0442\:0440\:043e\:0435\:043d\:0438\:044f k \:0442\:0430\:043a\:0438\:0445 \
\:0447\:0438\:0441\:0435\:043b \:043c\:043e\:0436\:043d\:043e \:0438\:0441\
\:043f\:043e\:043b\:044c\:0437\:043e\:0432\:0430\:0442\:044c \:043a\:043e\
\:043c\:0430\:043d\:0434\:0443 NextPrime[{a,b},k].\
\>", "Text",
 CellChangeTimes->{{3.49206257140899*^9, 3.4920626053233895`*^9}, {
  3.4920627051321898`*^9, 3.4920628798209896`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPrime", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"10", "^", "200"}], ",", 
    RowBox[{"10", "^", "300"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.4920623142273893`*^9, 3.4920623389689894`*^9}, {
  3.49206241955859*^9, 3.49206244189779*^9}, {3.4920625401465893`*^9, 
  3.4920625437033896`*^9}}],

Cell[BoxData[\
"75195502557045755655312193686645778267755861374369658928809533277286193081068\
806276665279296126195015572184938784873175607684046851893616417771988142157652\
937431001860686149335322663132074462823859996137316555159387215241237848364967\
4518172919125713046061169499731160419173471138450177971410600581953"], \
"Output",
 CellChangeTimes->{{3.4920623261613894`*^9, 3.49206234134019*^9}, 
   3.4920624663741894`*^9, 3.49206255109779*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPrime", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1000", ",", 
     RowBox[{"10", "^", "20"}]}], "}"}], ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.49206290581059*^9, 3.4920629738889894`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "31303623967409883053", ",", "67106988005895854777", ",", 
   "66358603370548881239"}], "}"}]], "Output",
 CellChangeTimes->{{3.4920629273853893`*^9, 3.4920629447949896`*^9}, 
   3.4920629756361895`*^9}]
}, Closed]],

Cell["\<\
\:0421\:0443\:0449\:0435\:0441\:0442\:0432\:0443\:044e\:0442 \:0430\:043b\
\:0433\:043e\:0440\:0438\:0442\:043c\:044b, \:043f\:043e\:0437\:0432\:043e\
\:043b\:044f\:044e\:0449\:0438\:0435 \:0441\:0442\:0440\:043e\:0438\:0442\
\:044c \:0431\:043e\:043b\:044c\:0448\:0438\:0435 \:043f\:0440\:043e\:0441\
\:0442\:044b\:0435 \:0447\:0438\:0441\:043b\:0430 \:0441 \:0433\:0430\:0440\
\:0430\:043d\:0442\:0438\:0435\:0439 \:0442\:043e\:0433\:043e, \:0447\:0442\
\:043e \:044d\:0442\:0438 \:0447\:0438\:0441\:043b\:0430 \:043f\:0440\:043e\
\:0441\:0442\:044b\:0435. \:041e\:0434\:0438\:043d \:0438\:0437 \:0442\:0430\
\:043a\:0438\:0445 \:0430\:043b\:0433\:043e\:0440\:0438\:0442\:043c\:043e\
\:0432 \:043e\:043f\:0438\:0440\:0430\:0435\:0442\:0441\:044f \:043d\:0430 \
\:0441\:043b\:0435\:0434\:0443\:044e\:0449\:0443\:044e \:0442\:0435\:043e\
\:0440\:0435\:043c\:0443.\
\>", "Text",
 CellChangeTimes->{{3.495322751887*^9, 3.495322777139*^9}, {3.495322911969*^9,
   3.495322930289*^9}}],

Cell[TextData[{
 StyleBox["\:0422\:0435\:043e\:0440\:0435\:043c\:0430. ",
  FontWeight->"Bold"],
 StyleBox["\:041f\:0443\:0441\:0442\:044c N \:0438 F \:043d\:0435\:0447\:0435\
\:0442\:043d\:044b",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.495322931236*^9, 3.495322939125*^9}, {
   3.4953230145439997`*^9, 3.495323029267*^9}, 3.495323087117*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"N", "-", "1"}], " ", "=", " ", 
   RowBox[{"F", "\[CenterDot]", "R"}]}], ",", " ", 
  RowBox[{"R", " ", "\[LessEqual]", " ", 
   RowBox[{
    RowBox[{"4", "F"}], "+", "3"}]}], ","}]], "Equation",
 CellChangeTimes->{{3.495323045947*^9, 3.495323049888*^9}, {3.495323090314*^9,
   3.495323131033*^9}, {3.495323164991*^9, 3.495323193052*^9}, {
  3.49532322313*^9, 3.495323228645*^9}, {3.495324052995*^9, 
  3.495324053784*^9}},
 TextAlignment->Center],

Cell[TextData[StyleBox["\:043f\:0440\:0438\:0447\:0435\:043c \:0434\:043b\
\:044f \:043a\:0430\:0436\:0434\:043e\:0433\:043e \:043f\:0440\:043e\:0441\
\:0442\:043e\:0433\:043e \:0434\:0435\:043b\:0438\:0442\:0435\:043b\:044f q \
\:0447\:0438\:0441\:043b\:0430 F \:0441\:0443\:0449\:0435\:0441\:0442\:0432\
\:0443\:0435\:0442 \:0446\:0435\:043b\:043e\:0435 b \:0441 \:0443\:0441\:043b\
\:043e\:0432\:0438\:044f\:043c\:0438",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.495323205707*^9, 3.4953232123129997`*^9}, {
  3.4953232438570004`*^9, 3.4953232887349997`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["b", 
    RowBox[{"N", "-", "1"}]], "\[Congruent]", 
   RowBox[{"1", " ", 
    RowBox[{"(", 
     RowBox[{"mod", " ", "N"}], ")"}]}]}], ",", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"N", "-", "1"}], ")"}], "/", "q"}]], " ", "-", "1"}], ",", 
     " ", "N"}], ")"}], " ", "=", " ", "1."}]}]], "Equation",
 CellChangeTimes->{{3.495323304375*^9, 3.495323409332*^9}, {3.49532405712*^9, 
  3.4953240576879997`*^9}},
 TextAlignment->Center],

Cell[TextData[StyleBox["\:0422\:043e\:0433\:0434\:0430 N - \:043f\:0440\:043e\
\:0441\:0442\:043e\:0435 \:0447\:0438\:0441\:043b\:043e.",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.495292224828125*^9, 3.49529222484375*^9}, {
  3.495323420611*^9, 3.495323438565*^9}, {3.495323528099*^9, 
  3.495323528149*^9}}],

Cell["\<\
\:0421\:0444\:043e\:0440\:043c\:0443\:043b\:0438\:0440\:043e\:0432\:0430\:043d\
\:043d\:0430\:044f \:0442\:0435\:043e\:0440\:0435\:043c\:0430 \:043f\:043e\
\:0437\:0432\:043e\:043b\:044f\:0435\:0442, \:0438\:043c\:0435\:044f \:0431\
\:043e\:043b\:044c\:0448\:043e\:0435 \:043f\:0440\:043e\:0441\:0442\:043e \
\:0447\:0438\:0441\:043b\:043e F, \:0441\:0442\:0440\:043e\:0438\:0442\:044c \
\:0441\:0443\:0449\:0435\:0441\:0442\:0432\:0435\:043d\:043d\:043e \:0431\
\:041e\:043b\:044c\:0448\:0435\:0435 \:043f\:0440\:043e\:0441\:0442\:043e\
\:0435 \:0447\:0438\:0441\:043b\:043e N. \:0414\:043b\:044f \
\:044d\:0442\:043e\:0433\:043e \:0432\:044b\:0431\:0438\:0440\:0430\:0435\
\:043c \:0441\:043b\:0443\:0447\:0430\:0439\:043d\:044b\:043c \:043e\:0431\
\:0440\:0430\:0437\:043e\:043c \:0446\:0435\:043b\:043e\:0435 \:0447\:0438\
\:0441\:043b\:043e Q \:043d\:0430 \:043f\:0440\:043e\:043c\:0435\:0436\:0443\
\:0442\:043a\:0435 F \[LessEqual] Q \[LessEqual] 2F + 1 \:0438 \:043f\:043e\
\:043b\:043e\:0436\:0438\:043c N = 2FQ + 1. \:0417\:0430\:0442\:0435\:043c \
\:043c\:043e\:0436\:043d\:043e \:043f\:0440\:043e\:0432\:0435\:0440\:0438\
\:0442\:044c \:0447\:0438\:0441\:043b\:043e N \:0441 \:043f\:043e\:043c\:043e\
\:0449\:044c\:044e \:0444\:0443\:043d\:043a\:0446\:0438\:0438 PrimeQ. \:0415\
\:0441\:043b\:0438 \:043e\:043d\:0430 \:0432\:044b\:0434\:0430\:0441\:0442 \
False, \:0437\:043d\:0430\:0447\:0438\:0442, \:0447\:0438\:0441\:043b\:043e N \
\:0433\:0430\:0440\:0430\:043d\:0442\:0438\:0440\:043e\:0432\:0430\:043d\:043d\
\:043e \:0441\:043e\:0441\:0442\:0430\:0432\:043d\:043e\:0435 \:0438 \:043d\
\:0430\:0434\:043e \:043f\:0435\:0440\:0435\:0445\:043e\:0434\:0438\:0442\
\:044c \:043a \:043d\:043e\:0432\:043e\:043c\:0443 \:0437\:043d\:0430\:0447\
\:0435\:043d\:0438\:044e Q. \:0415\:0441\:043b\:0438 \:0436\:0435 PrimeQ \
\:0432\:044b\:0434\:0430\:0441\:0442 True, \:0442\:043e \:043c\:043e\:0436\
\:043d\:043e \:043f\:0435\:0440\:0435\:0445\:043e\:0434\:0438\:0442\:044c \
\:043a \:0434\:043e\:043a\:0430\:0437\:0430\:0442\:0435\:043b\:044c\:0441\
\:0442\:0432\:0443 \:043f\:0440\:043e\:0441\:0442\:043e\:0442\:044b N. \:0414\
\:043b\:044f \:044d\:0442\:043e\:0433\:043e \:043d\:0430\:0434\:043e \:0432\
\:044b\:0431\:0440\:0430\:0442\:044c \:0441\:043b\:0443\:0447\:0430\:0439\
\:043d\:043e b, 1 < b < N, \:0438 \:043f\:0440\:043e\:0432\:0435\:0440\:0438\
\:0442\:044c \:0434\:043b\:044f \:043d\:0435\:0433\:043e \:0432\:044b\:043f\
\:043e\:043b\:043d\:0438\:043c\:043e\:0441\:0442\:044c \:0443\:0441\:043b\
\:043e\:0432\:0438\:0439 \:0442\:0435\:043e\:0440\:0435\:043c\:044b. \:0415\
\:0441\:043b\:0438 \:043f\:0440\:0438 \:0432\:044b\:0431\:0440\:0430\:043d\
\:043d\:043e\:043c b \:0431\:0443\:0434\:0443\:0442 \:0432\:044b\:043f\:043e\
\:043b\:043d\:0435\:043d\:044b \:0441\:043e\:043e\:0442\:043d\:043e\:0448\
\:0435\:043d\:0438\:044f\
\>", "Text",
 CellChangeTimes->{{3.495323537668*^9, 3.495323744935*^9}, {3.495323784999*^9,
   3.495323858613*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["b", 
    RowBox[{"N", "-", "1"}]], "\[Congruent]", 
   RowBox[{"1", " ", 
    RowBox[{"(", 
     RowBox[{"mod", " ", "N"}], ")"}]}]}], ",", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", 
       RowBox[{"2", "Q"}]], " ", "-", "1"}], ",", " ", "N"}], ")"}], " ", "=",
    " ", "1"}], ","}]], "Equation",
 CellChangeTimes->{{3.495323866417*^9, 3.495323910368*^9}, {3.495324068584*^9,
   3.495324069349*^9}},
 TextAlignment->Center],

Cell["\<\
\:0442\:043e, \:043f\:043e\:0441\:043a\:043e\:043b\:044c\:043a\:0443 2Q \
\[LessEqual] 4F + 2 < 4F + 3, \:0432 \:0441\:043e\:043e\:0442\:0432\:0435\
\:0442\:0441\:0442\:0432\:0438\:0438 \:0441\:043e \:0441\:0444\:043e\:0440\
\:043c\:0443\:043b\:0438\:0440\:043e\:0432\:0430\:043d\:043d\:043e\:0439 \
\:0442\:0435\:043e\:0440\:0435\:043c\:043e\:0439, \:0447\:0438\:0441\:043b\
\:043e N \:043e\:043a\:0430\:0436\:0435\:0442\:0441\:044f \:043f\:0440\:043e\
\:0441\:0442\:044b\:043c.\
\>", "Text",
 CellChangeTimes->{{3.4953239144370003`*^9, 3.495323971413*^9}}],

Cell[" ", "Text",
 CellChangeTimes->{3.495323937665*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\:0420\:0430\:0437\:043b\:043e\:0436\:0435\:043d\:0438\:0435 \:0447\
\:0438\:0441\:0435\:043b \:043d\:0430 \:043c\:043d\:043e\:0436\:0438\:0442\
\:0435\:043b\:0438", "Section",
 CellChangeTimes->{{3.49529222709375*^9, 3.495292231046875*^9}, {
  3.49529232228125*^9, 3.495292365953125*^9}, {3.49529256896875*^9, 
  3.495292569765625*^9}, {3.4953188286610003`*^9, 3.495318836224*^9}}],

Cell["\<\
\:0424\:0443\:043d\:043a\:0446\:0438\:044f FactorInteger[n] \
\:0432\:044b\:0434\:0430\:0435\:0442 \:0440\:0430\:0437\:043b\:043e\:0436\
\:0435\:043d\:0438\:0435 \:0447\:0438\:0441\:043b\:0430 n \:043d\:0430 \:043f\
\:0440\:043e\:0441\:0442\:044b\:0435 \:043c\:043d\:043e\:0436\:0438\:0442\
\:0435\:043b\:0438 \:0432 \:0441\:043b\:0435\:0434\:0443\:044e\:0449\:0435\
\:043c \:0432\:0438\:0434\:0435\
\>", "Text",
 CellChangeTimes->{{3.495292574171875*^9, 3.495292574859375*^9}, {
  3.495318928366*^9, 3.4953189535369997`*^9}, {3.49532326591*^9, 
  3.495323267434*^9}}],

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "1000", "]"}]], "Input",
 CellChangeTimes->{{3.495318961426*^9, 3.495319000903*^9}}],

Cell["\<\
FactorInteger[n, k] \:043e\:0441\:0443\:0449\:0435\:0441\:0442\:0432\:043b\
\:044f\:0435\:0442 \:0447\:0430\:0441\:0442\:0438\:0447\:043d\:0443\:044e \
\:0444\:0430\:043a\:0442\:043e\:0440\:0438\:0437\:0430\:0446\:0438\:044e, \
\:043d\:0430\:0445\:043e\:0434\:044f \:043d\:0435 \:043c\:0435\:043d\:0435\
\:0435 k \:0440\:0430\:0437\:043b\:0438\:0447\:043d\:044b\:0445 \:043f\:0440\
\:043e\:0441\:0442\:044b\:0445 \:0434\:0435\:043b\:0438\:0442\:0435\:043b\
\:0435\:0439\
\>", "Text",
 CellChangeTimes->{{3.4953190449379997`*^9, 3.495319093335*^9}, {
  3.495319180817*^9, 3.49531918326*^9}}],

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"720", ",", " ", "4"}], "]"}]], "Input",
 CellChangeTimes->{{3.495319106041*^9, 3.4953191332209997`*^9}}],

Cell["\<\
\:0414\:043b\:044f \:043e\:0442\:0440\:0438\:0446\:0430\:0442\:0435\:043b\
\:044c\:043d\:044b\:0445 \:0447\:0438\:0441\:0435\:043b \:0435\:0434\:0438\
\:043d\:0438\:0446\:0430 {-1, 1} \:0432\:043a\:043b\:044e\:0447\:0430\:0435\
\:0442\:0441\:044f \:0432 \:0441\:043f\:0438\:0441\:043e\:043a \:0434\:0435\
\:043b\:0438\:0442\:0435\:043b\:0435\:0439. \:0424\:0443\:043d\:043a\:0446\
\:0438\:044f FactorInteger \:0440\:0430\:0431\:043e\:0442\:0430\:0435\:0442 \
\:0438 \:0441 \:0440\:0430\:0446\:0438\:043e\:043d\:0430\:043b\:044c\:043d\
\:044b\:043c\:0438 \:0447\:0438\:0441\:043b\:0430\:043c\:0438, \:043f\:0440\
\:0438 \:044d\:0442\:043e\:043c \:0441\:0442\:0435\:043f\:0435\:043d\:0438 \
\:043f\:0440\:043e\:0441\:0442\:044b\:0445 \:0447\:0438\:0441\:0435\:043b, \
\:0432\:0445\:043e\:0434\:044f\:0449\:0438\:0445 \:0432 \:0437\:043d\:0430\
\:043c\:0435\:043d\:0430\:0442\:0435\:043b\:044c, \:0432\:044b\:0434\:0430\
\:044e\:0442\:0441\:044f \:0441\:043e \:0437\:043d\:0430\:043a\:043e\:043c \"\
\:043c\:0438\:043d\:0443\:0441\"\
\>", "Text",
 CellChangeTimes->{{3.49529093725*^9, 3.495290937265625*^9}, {
  3.495319194315*^9, 3.495319325915*^9}, {3.4953193899189997`*^9, 
  3.4953193907799997`*^9}}],

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"1001", "/", "720"}], "]"}]], "Input",
 CellChangeTimes->{{3.4953193922869997`*^9, 3.4953194402679996`*^9}, {
  3.4953194724700003`*^9, 3.495319490131*^9}}],

Cell[TextData[{
 StyleBox["\:0412\:043e\:043f\:0440\:043e\:0441",
  FontWeight->"Bold"],
 ". \:041a\:0430\:043a \:043f\:043e\:0432\:0435\:0434\:0435\:0442 \
\:0441\:0435\:0431\:044f \:0444\:0443\:043d\:043a\:0446\:0438\:044f \
FactorInteger, \:0435\:0441\:043b\:0438 \:043f\:0435\:0440\:0432\:044b\:0439 \
\:0430\:0440\:0433\:0443\:043c\:0435\:043d\:0442 - \:0440\:0430\:0446\:0438\
\:043e\:043d\:0430\:043b\:044c\:043d\:043e\:0435 \:0447\:0438\:0441\:043b\
\:043e \:0438 \:0437\:0430\:0434\:0430\:043d \:043d\:0435\:043a\:043e\:0442\
\:043e\:0440\:044b\:0439 \:0432\:0442\:043e\:0440\:043e\:0439 \:0430\:0440\
\:0433\:0443\:043c\:0435\:043d\:0442 k? "
}], "Text",
 CellChangeTimes->{{3.495319602413*^9, 3.495319604098*^9}}],

Cell["\<\
\:041f\:043e\:043c\:0438\:043c\:043e \:0446\:0435\:043b\:044b\:0445 \:0438 \
\:0440\:0430\:0446\:0438\:043e\:043d\:0430\:043b\:044c\:043d\:044b\:0445 \
\:0447\:0438\:0441\:0435\:043b, FactorInteger \:043c\:043e\:0436\:0435\:0442 \
\:0440\:0430\:0431\:043e\:0442\:0430\:0442\:044c \:0441 \:0446\:0435\:043b\
\:044b\:043c\:0438 \:0433\:0430\:0443\:0441\:0441\:043e\:0432\:044b\:043c\
\:0438 \:0447\:0438\:0441\:043b\:0430\:043c\:0438. \:0414\:043b\:044f \:044d\
\:0442\:043e\:0433\:043e \:0441\:0443\:0449\:0435\:0441\:0442\:0432\:0443\
\:044e\:0442 \:0434\:0432\:0435 \:0440\:0430\:0437\:043b\:0438\:0447\:043d\
\:044b\:0435 \:0437\:0430\:043f\:0438\:0441\:0438\
\>", "Text",
 CellChangeTimes->{{3.495319607382*^9, 3.495319629374*^9}, {3.495319669263*^9,
   3.495319685593*^9}}],

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"17", ",", " ", 
   RowBox[{"GaussianIntegers", " ", "\[Rule]", " ", "True"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.495319688942*^9, 3.495319748106*^9}}],

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"17", "+", 
   RowBox[{"I", " ", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4953196891429996`*^9, 3.4953196891879997`*^9}, {
  3.495319790266*^9, 3.495319826236*^9}}],

Cell[TextData[{
 "\:041f\:0440\:0438 \:0440\:0430\:0431\:043e\:0442\:0435 \:0441 \:0433\:0430\
\:0443\:0441\:0441\:043e\:0432\:044b\:043c\:0438 \:0447\:0438\:0441\:043b\
\:0430\:043c\:0438 \:043f\:043e \:043c\:0435\:0440\:0435 \:043d\:0435\:043e\
\:0431\:0445\:043e\:0434\:0438\:043c\:043e\:0441\:0442\:0438 \:0432 \:0441\
\:043f\:0438\:0441\:043e\:043a \:0434\:0435\:043b\:0438\:0442\:0435\:043b\
\:0435\:0439 \:0432\:043a\:043b\:044e\:0447\:0430\:044e\:0442\:0441\:044f \
\:0435\:0434\:0438\:043d\:0438\:0446\:044b {-1, 1},  ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["I",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/I"], ",", "1"}], "}"}]], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     ButtonBox["I",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/I"]}], ",", "1"}], "}"}]], "InlineFormula"],
 "."
}], "Text",
 CellChangeTimes->{{3.495319878*^9, 3.495319920566*^9}, {3.495319950613*^9, 
  3.495319968584*^9}}],

Cell["\<\
\:0414\:043b\:044f \:043e\:043f\:0440\:0435\:0434\:0435\:043b\:0435\:043d\
\:0438\:044f \:0442\:043e\:0433\:043e \:0444\:0430\:043a\:0442\:0430, \:0447\
\:0442\:043e \:043e\:0447\:0435\:0440\:0435\:0434\:043d\:043e\:0439 \:0434\
\:0435\:043b\:0438\:0442\:0435\:043b\:044c \:044f\:0432\:043b\:044f\:0435\
\:0442\:0441\:044f \:043f\:0440\:043e\:0441\:0442\:044b\:043c, FactorInteger \
\:0438\:0441\:043f\:043e\:043b\:044c\:0437\:0443\:0435\:0442 \:0444\:0443\
\:043d\:043a\:0446\:0438\:044e PrimeQ.\
\>", "Text",
 CellChangeTimes->{{3.495320311125*^9, 3.495320479066*^9}, {3.495320880288*^9,
   3.495320880408*^9}, {3.495320990972*^9, 3.495320998723*^9}}],

Cell["\<\
\:041c\:043e\:0436\:043d\:043e \:0437\:0430\:043f\:0438\:0441\:044b\:0432\
\:0430\:0442\:044c \:0440\:0435\:0437\:0443\:043b\:044c\:0442\:0430\:0442 \
\:0440\:0430\:0437\:043b\:043e\:0436\:0435\:043d\:0438\:044f \:043d\:0430 \
\:043c\:043d\:043e\:0436\:0438\:0442\:0435\:043b\:0438 \:0432 \:0431\:043e\
\:043b\:0435\:0435 \:043f\:0440\:0438\:0432\:044b\:0447\:043d\:043e\:043c \
\:0432\:0438\:0434\:0435\
\>", "Text",
 CellChangeTimes->{{3.4953205208570004`*^9, 3.495320546948*^9}}],

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"20", "!"}], "]"}]], "Input",
 CellChangeTimes->{3.495320560693*^9}],

Cell[BoxData[
 RowBox[{"CenterDot", "@@", 
  RowBox[{"(", 
   RowBox[{"Superscript", "@@@", "%"}], ")"}]}]], "Input",
 CellChangeTimes->{3.495320580156*^9}],

Cell[" ", "Text",
 CellChangeTimes->{{3.4953207927679996`*^9, 3.495320799362*^9}, {
  3.4953208658120003`*^9, 3.495320888026*^9}, {3.4953224453310003`*^9, 
  3.49532244667*^9}}],

Cell["", "Text",
 CellChangeTimes->{{3.495320897354*^9, 3.495320897362*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\:0423\:043f\:0440\:0430\:0436\:043d\:0435\:043d\:0438\:044f", "Section",
 CellChangeTimes->{{3.495320899509*^9, 3.495320908066*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 1***.",
  FontWeight->"Bold"],
 " \:041f\:0440\:0438\:0432\:0435\:0441\:0442\:0438 \:043f\:0440\:0438\:043c\
\:0435\:0440 (\:043d\:0435\:0442\:0440\:0438\:0432\:0438\:0430\:043b\:044c\
\:043d\:043e\:0433\:043e) \:0447\:0438\:0441\:043b\:0430 n \:0442\:0430\:043a\
\:043e\:0433\:043e, \:0447\:0442\:043e PrimeQ[n] \:0432\:044b\:0434\:0430\
\:0435\:0442 True, \:0430 ProvablePrimeQ[n] \:0432\:044b\:0434\:0430\:0435\
\:0442 False."
}], "Text",
 CellChangeTimes->{{3.495320920818*^9, 3.495320928435*^9}, {3.495320961494*^9,
   3.495320980644*^9}, {3.495321093351*^9, 3.495321093428*^9}, {
  3.495321123453*^9, 3.495321130201*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:043c\:0435\:0447\:0430\:043d\:0438\:0435",
  FontSlant->"Italic"],
 ". \:0417\:0430\:0434\:0430\:0447\:0430 \:043d\:0435 \
\:043e\:0431\:044f\:0437\:0430\:0442\:0435\:043b\:044c\:043d\:0430\:044f. \
\:041f\:0435\:0440\:0432\:044b\:0439 \:0447\:0435\:043b\:043e\:0432\:0435\
\:043a, \:043f\:0440\:0435\:0434\:044a\:044f\:0432\:0438\:0432\:0448\:0438\
\:0439 \:0440\:0435\:0448\:0435\:043d\:0438\:0435, \:043f\:043e\:043b\:0443\
\:0447\:0430\:0435\:0442 \:0437\:0430\:0447\:0435\:0442 \:0430\:0432\:0442\
\:043e\:043c\:0430\:0442\:043e\:043c."
}], "Text",
 CellChangeTimes->{
  3.4953211931619997`*^9, {3.495322790266*^9, 3.495322790402*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 2.",
  FontWeight->"Bold"],
 " \:041e\:043f\:0440\:0435\:0434\:0435\:043b\:0438\:0442\:044c \:043e\:0431\
\:043b\:0430\:0441\:0442\:044c \:043f\:0440\:0438\:043c\:0435\:043d\:0438\
\:043c\:043e\:0441\:0442\:0438 \:0444\:0443\:043d\:043a\:0446\:0438\:0438 \
ProvablePrimeQ."
}], "Text",
 CellChangeTimes->{{3.4953227918529997`*^9, 3.4953228105150003`*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 3.",
  FontWeight->"Bold"],
 " \:041e\:043f\:0440\:0435\:0434\:0435\:043b\:0438\:0442\:044c \:043e\:0431\
\:043b\:0430\:0441\:0442\:044c \:043f\:0440\:0438\:043c\:0435\:043d\:0438\
\:043c\:043e\:0441\:0442\:0438 \:0444\:0443\:043d\:043a\:0446\:0438\:0438 \
FactorInteger - \:043d\:0430 \:0441\:043a\:043e\:043b\:044c\:043a\:043e \
\:0431\:043e\:043b\:044c\:0448\:0438\:0435 \:0447\:0438\:0441\:043b\:0430 \
\:043e\:0431\:0449\:0435\:0433\:043e \:0432\:0438\:0434\:0430 \:043c\:043e\
\:0436\:043d\:043e \:0433\:0430\:0440\:0430\:043d\:0442\:0438\:0440\:043e\
\:0432\:0430\:043d\:043d\:043e \:0440\:0430\:0437\:043b\:043e\:0436\:0438\
\:0442\:044c \:044d\:0442\:043e\:0439 \:0444\:0443\:043d\:043a\:0446\:0438\
\:0435\:0439 \:0437\:0430 \:0440\:0430\:0437\:0443\:043c\:043d\:043e\:0435 \
\:0432\:0440\:0435\:043c\:044f (1 \:043c\:0438\:043d\:0443\:0442\:0430)? \
\:0421\:0447\:0438\:0442\:0430\:0442\:044c, \:0447\:0442\:043e \:043d\:0430\
\:0438\:0431\:043e\:043b\:044c\:0448\:0430\:044f \:0441\:043b\:043e\:0436\
\:043d\:043e\:0441\:0442\:044c \:0440\:0430\:0437\:043b\:043e\:0436\:0435\
\:043d\:0438\:044f \:0434\:043e\:0441\:0442\:0438\:0433\:0430\:0435\:0442\
\:0441\:044f \:043d\:0430 \:0447\:0438\:0441\:043b\:0430\:0445, \:043a\:043e\
\:0442\:043e\:0440\:044b\:0435 \:044f\:0432\:043b\:044f\:044e\:0442\:0441\
\:044f \:043f\:0440\:043e\:0438\:0437\:0432\:0435\:0434\:0435\:043d\:0438\
\:043c \:0434\:0432\:0443\:0445 \:043f\:0440\:043e\:0441\:0442\:044b\:0445, \
\:043e\:0442\:043b\:0438\:0447\:0430\:044e\:0449\:0438\:0445\:0441\:044f \
\:0434\:0440\:0443\:0433 \:043e\:0442 \:0434\:0440\:0443\:0433\:0430 \:043f\
\:0440\:0438\:043c\:0435\:0440\:043d\:043e \:0432 2-7 \:0440\:0430\:0437."
}], "Text",
 CellChangeTimes->{{3.495320981894*^9, 3.495321004334*^9}, {
  3.4953239959300003`*^9, 3.495323996106*^9}, {3.495324153064*^9, 
  3.495324160992*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 4. ",
  FontWeight->"Bold"],
 "\:041f\:0440\:0435\:0434\:044a\:044f\:0432\:0438\:0442\:044c \:0441\:043f\
\:0438\:0441\:043e\:043a \:0447\:0438\:0441\:0435\:043b \:043c\:0435\:0436\
\:0434\:0443 10^40 \:0438 10^40 + 100, \:0432 \:0440\:0430\:0437\:043b\:043e\
\:0436\:0435\:043d\:0438\:0435 \:043a\:043e\:0442\:043e\:0440\:044b\:0445 \
\:0432\:0445\:043e\:0434\:044f\:0442 \:0440\:043e\:0432\:043d\:043e \:0434\
\:0432\:0430 \:043f\:0440\:043e\:0441\:0442\:044b\:0445 \:0434\:0435\:043b\
\:0438\:0442\:0435\:043b\:044f."
}], "Text",
 CellChangeTimes->{{3.495321005516*^9, 3.495321007013*^9}, {3.495321206552*^9,
   3.4953212791470003`*^9}, {3.495321904135*^9, 3.495321906726*^9}, {
  3.495324000226*^9, 3.495324000382*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 5. ",
  FontWeight->"Bold"],
 "\:041d\:0430\:0439\:0442\:0438 \:0432\:0441\:0435 \:043f\:0440\:043e\:0441\
\:0442\:044b\:0435 \:0447\:0438\:0441\:043b\:0430 p \:043c\:0435\:0436\:0434\
\:0443 100 \:0438 1000 \:0442\:0430\:043a\:0438\:0435, \:0447\:0442\:043e \
\:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d x^12+x+1 \:0440\:0430\
\:0441\:043a\:043b\:0430\:0434\:044b\:0432\:0430\:0435\:0442\:0441\:044f \
\:043d\:0430 \:043b\:0438\:043d\:0435\:0439\:043d\:044b\:0435 \:043c\:043d\
\:043e\:0436\:0438\:0442\:0435\:043b\:0438 \:043d\:0430\:0434 \:043f\:043e\
\:043b\:0435\:043c \:0438\:0437 p \:044d\:043b\:0435\:043c\:0435\:043d\:0442\
\:043e\:0432. "
}], "Text",
 CellChangeTimes->{{3.495322329574*^9, 3.4953224010620003`*^9}, {
  3.495322831509*^9, 3.495322831604*^9}, {3.4953240038710003`*^9, 
  3.495324005035*^9}}],

Cell[TextData[{
 StyleBox["\:0417\:0430\:0434\:0430\:0447\:0430 6.",
  FontWeight->"Bold"],
 " \:041f\:043e\:0441\:0442\:0440\:043e\:0438\:0442\:044c (\:0433\:0430\:0440\
\:0430\:043d\:0442\:0438\:0440\:043e\:0432\:0430\:043d\:043d\:043e) \:043f\
\:0440\:043e\:0441\:0442\:043e\:0435 \:0447\:0438\:0441\:043b\:043e \:0438\
\:0437 \:043f\:0440\:043e\:043c\:0435\:0436\:0443\:0442\:043a\:0430 [",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "1000"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "1000"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " + ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "100"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "]."
}], "Text",
 CellChangeTimes->{{3.495322832657*^9, 3.495322895725*^9}, {
  3.4953240081809998`*^9, 3.495324008326*^9}, {3.495324188326*^9, 
  3.495324217218*^9}}],

Cell["", "Text"],

Cell["", "Text",
 CellChangeTimes->{{3.495321290508*^9, 3.49532129051*^9}}]
}, Closed]]
}, Open  ]]
},
WindowSize->{1264, 679},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (May 21, 2008)",
StyleDefinitions->FrontEnd`FileName[{"Book"}, "Textbook.nb", 
  CharacterEncoding -> "WindowsCyrillic"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 74, 1, 217, "BookChapterNumber"],
Cell[667, 26, 237, 3, 194, "BookChapterTitle"],
Cell[CellGroupData[{
Cell[929, 33, 161, 2, 86, "Section"],
Cell[1093, 37, 1963, 31, 106, "Text"],
Cell[3059, 70, 482, 8, 32, "Text"],
Cell[CellGroupData[{
Cell[3566, 82, 133, 2, 43, "Input"],
Cell[3702, 86, 76, 1, 141, "Output"]
}, Closed]],
Cell[3793, 90, 130, 2, 32, "Input"],
Cell[3926, 94, 3243, 46, 155, "Text"],
Cell[7172, 142, 177, 3, 43, "Input"],
Cell[7352, 147, 334, 6, 43, "Input"],
Cell[7689, 155, 276, 6, 43, "Input"],
Cell[7968, 163, 733, 11, 32, "Text"],
Cell[8704, 176, 518, 9, 32, "Text"],
Cell[CellGroupData[{
Cell[9247, 189, 184, 3, 43, "Input"],
Cell[9434, 194, 128, 2, 141, "Output"]
}, Closed]],
Cell[9577, 199, 692, 10, 53, "Text"],
Cell[10272, 211, 151, 3, 43, "Input"],
Cell[10426, 216, 149, 3, 43, "Input"],
Cell[10578, 221, 125, 3, 43, "Input"],
Cell[10706, 226, 501, 10, 34, "Text"],
Cell[CellGroupData[{
Cell[11232, 240, 1207, 29, 43, "Input"],
Cell[12442, 271, 424, 9, 141, "Output"]
}, Closed]],
Cell[12881, 283, 916, 13, 53, "Text"],
Cell[CellGroupData[{
Cell[13822, 300, 229, 4, 43, "Input"],
Cell[14054, 306, 199, 3, 141, "Output"]
}, Closed]],
Cell[14268, 312, 351, 6, 28, "Text"],
Cell[14622, 320, 202, 6, 43, "Input"],
Cell[14827, 328, 398, 7, 32, "Text"],
Cell[15228, 337, 286, 9, 43, "Input"],
Cell[15517, 348, 609, 10, 32, "Text"],
Cell[16129, 360, 261, 7, 43, "Input"],
Cell[16393, 369, 269, 7, 43, "Input"],
Cell[16665, 378, 663, 11, 32, "Text"],
Cell[17331, 391, 359, 10, 43, "Input"],
Cell[17693, 403, 560, 9, 32, "Text"],
Cell[18256, 414, 393, 11, 43, "Input"],
Cell[18652, 427, 498, 8, 32, "Text"],
Cell[19153, 437, 367, 10, 43, "Input"],
Cell[19523, 449, 759, 11, 32, "Text"],
Cell[20285, 462, 462, 8, 32, "Text"],
Cell[20750, 472, 123, 3, 43, "Input"],
Cell[20876, 477, 444, 7, 32, "Text"],
Cell[21323, 486, 208, 6, 43, "Input"],
Cell[21534, 494, 305, 4, 32, "Text"],
Cell[21842, 500, 282, 7, 43, "Input"],
Cell[22127, 509, 415, 7, 32, "Text"],
Cell[22545, 518, 381, 11, 43, "Input"],
Cell[22929, 531, 583, 16, 37, "Text"],
Cell[23515, 549, 1496, 30, 63, "Text"],
Cell[25014, 581, 326, 9, 43, "Input"],
Cell[25343, 592, 464, 8, 32, "Text"],
Cell[25810, 602, 474, 11, 43, "Input"],
Cell[26287, 615, 867, 13, 57, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[27191, 633, 262, 5, 54, "Section"],
Cell[27456, 640, 568, 9, 32, "Text"],
Cell[CellGroupData[{
Cell[28049, 653, 211, 4, 43, "Input"],
Cell[28263, 659, 461, 7, 397, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[28761, 671, 269, 7, 32, "Input"],
Cell[29033, 680, 1453, 21, 1410, "Output"]
}, Closed]],
Cell[30501, 704, 3136, 44, 126, "Text"],
Cell[33640, 750, 1029, 15, 57, "Text"],
Cell[CellGroupData[{
Cell[34694, 769, 337, 8, 43, "Input"],
Cell[35034, 779, 453, 7, 397, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[35524, 791, 234, 6, 32, "Input"],
Cell[35761, 799, 245, 6, 141, "Output"]
}, Closed]],
Cell[36021, 808, 990, 15, 53, "Text"],
Cell[37014, 825, 359, 8, 32, "Text"],
Cell[37376, 835, 494, 12, 41, "Equation"],
Cell[37873, 849, 573, 8, 32, "Text"],
Cell[38449, 859, 589, 19, 47, "Equation"],
Cell[39041, 880, 320, 5, 32, "Text"],
Cell[39364, 887, 2977, 41, 130, "Text"],
Cell[42344, 930, 523, 17, 47, "Equation"],
Cell[42870, 949, 568, 9, 32, "Text"],
Cell[43441, 960, 56, 1, 32, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[43534, 966, 388, 5, 54, "Section"],
Cell[43925, 973, 578, 10, 32, "Text"],
Cell[44506, 985, 129, 2, 43, "Input"],
Cell[44638, 989, 600, 10, 32, "Text"],
Cell[45241, 1001, 161, 3, 43, "Input"],
Cell[45405, 1006, 1211, 18, 57, "Text"],
Cell[46619, 1026, 212, 4, 43, "Input"],
Cell[46834, 1032, 724, 12, 57, "Text"],
Cell[47561, 1046, 787, 12, 57, "Text"],
Cell[48351, 1060, 216, 5, 43, "Input"],
Cell[48570, 1067, 227, 5, 43, "Input"],
Cell[48800, 1074, 993, 25, 62, "Text"],
Cell[49796, 1101, 663, 10, 57, "Text"],
Cell[50462, 1113, 492, 8, 32, "Text"],
Cell[50957, 1123, 124, 3, 43, "Input"],
Cell[51084, 1128, 156, 4, 43, "Input"],
Cell[51243, 1134, 177, 3, 32, "Text"],
Cell[51423, 1139, 76, 1, 32, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[51536, 1145, 139, 1, 54, "Section"],
Cell[51678, 1148, 691, 12, 32, "Text"],
Cell[52372, 1162, 681, 12, 32, "Text"],
Cell[53056, 1176, 419, 8, 32, "Text"],
Cell[53478, 1186, 1922, 28, 81, "Text"],
Cell[55403, 1216, 787, 13, 32, "Text"],
Cell[56193, 1231, 891, 15, 57, "Text"],
Cell[57087, 1248, 913, 25, 34, "Text"],
Cell[58003, 1275, 16, 0, 32, "Text"],
Cell[58022, 1277, 75, 1, 32, "Text"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
